# coding: utf-8
import sys, os
import pickle
import numpy as np
import numpy
from layers import *
from PIL import Image
import matplotlib.pyplot as plt
from collections import OrderedDict
import pandas as pd


class TwoLayerNet2:

    def __init__(self, w1,b1,w2,b2):
        # 重みの初期化
        self.params = {}
        self.params['W1'] = w1
        self.params['b1'] = b1
        self.params['W2'] = w2
        self.params['b2'] = b2
        
    def predict(self, x):
        W1, W2 = self.params['W1'], self.params['W2']
        b1, b2 = self.params['b1'], self.params['b2']
    
        a1 = np.dot(x, W1) + b1
        z1 = sigmoid(a1)
        a2 = np.dot(z1, W2) + b2
        y = softmax(a2)
        
        return y
        
    # x:入力データ, t:教師データ
    def loss(self, x, t):
        y = self.predict(x)
        
        return cross_entropy_error(y, t)


#モデルを読みだす
with open('My_w1.pkl', 'rb') as  pikle_w1:
  My_w1 = pickle.load( pikle_w1)
with open('My_b1.pkl', 'rb') as  pikle_b1:
  My_b1 = pickle.load( pikle_b1)
with open('My_w2.pkl', 'rb') as  pikle_w2:
  My_w2 = pickle.load( pikle_w2)
with open('My_b2.pkl', 'rb') as  pikle_b2:
  My_b2 = pickle.load( pikle_b2)
network2 = TwoLayerNet2(My_w1,My_b1,My_w2,My_b2)
print(My_w1.shape)
print(My_b1.shape)
print(My_w2.shape)
print(My_b2.shape)

#これを有効にするとモデルがCSVで出力できる
#df = pd.DataFrame(My_w1)
#df.to_csv('myfile.csv')

#                    <      Number1     ><     Number2       > 
#                    [0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9])
myimg_array=np.array([0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0])

myimg_array=np.array(myimg_array.flatten())

myimg_array=myimg_array.reshape(1,20)
print(myimg_array.shape)
y = network2.predict(myimg_array)
print(y)
p=np.argmax(y)
print(p)
