import pandas as pd
import sys, os
import numpy as np
#import matplotlib.pyplot as plt
from two_layer_net import TwoLayerNet
import pickle

#CSVを読み込む
x_train = pd.read_csv("xtrain.csv")
header = x_train.columns.values
x_train_data = x_train.values
print(header)
print(x_train_data)
print(x_train.shape)

t_train = pd.read_csv("ttrain.csv")
header = t_train.columns.values
t_train_data = t_train.values
print(header)
print(t_train_data)
print(t_train.shape)

x_test = pd.read_csv("xtest.csv")
header = x_test.columns.values
x_test_data = x_test.values
print(header)
print(x_test_data)
print(x_test.shape)

t_test = pd.read_csv("ttest.csv")
header = t_test.columns.values
t_test_data = t_test.values
print(header)
print(t_test_data)
print(t_test.shape)

#モデル作成とパラメータ設定
network = TwoLayerNet(input_size=20, hidden_size=100, output_size=20)

iters_num = 10000 # 繰り返しの回数を適宜設定する
train_size = x_train_data.shape[0]
batch_size = 100
learning_rate = 0.5

train_loss_list = []
train_acc_list = []
test_acc_list = []

iter_per_epoch = max(train_size / batch_size, 1)

_batch = x_train_data[0]

#学習部分
for i in range(iters_num):
    batch_mask = np.random.choice(train_size, batch_size)
    x_batch = x_train_data[batch_mask]
    t_batch = t_train_data[batch_mask]
    
    # 勾配
    #grad = network.numerical_gradient(x_batch, t_batch)
    grad = network.gradient(x_batch, t_batch)
    
    # 更新
    for key in ('W1', 'b1', 'W2', 'b2'):
        network.params[key] -= learning_rate * grad[key]
    
    loss = network.loss(x_batch, t_batch)
    train_loss_list.append(loss)
    
    if i % iter_per_epoch == 0:
        train_acc = network.accuracy(x_train_data, t_train_data)
        test_acc = network.accuracy(x_test_data, t_test_data)
        train_acc_list.append(train_acc)
        test_acc_list.append(test_acc)
        print(train_acc, test_acc)

#モデルを保存（ファイルにする）
techacademy = network.params['W1']
with open('My_w1.pkl', 'wb') as pikle_w1:
  pickle.dump(techacademy , pikle_w1)
  
techacademy = network.params['W2']
with open('My_w2.pkl', 'wb') as pikle_w2:
  pickle.dump(techacademy , pikle_w2)
  
techacademy = network.params['b1']
with open('My_b1.pkl', 'wb') as pikle_b1:
  pickle.dump(techacademy , pikle_b1)
  
techacademy = network.params['b2']
with open('My_b2.pkl', 'wb') as pikle_b2:
  pickle.dump(techacademy , pikle_b2)
